function getCfgCmd(cfgcmd){
    var cfgcmdlist = {
      1:   "ConfigReportReq",
      129: "ConfigReportRsp",
      2:   "ReadConfigReportReq",
      130: "ReadConfigReportRsp"
    };
    return cfgcmdlist[cfgcmd];
  }
  
  function getCmdToID(cmdtype){
    if (cmdtype == "ConfigReportReq")
        return 1;
    else if (cmdtype == "ConfigReportRsp")
        return 129;
    else if (cmdtype == "ReadConfigReportReq")
        return 2;
    else if (cmdtype == "ReadConfigReportRsp")
        return 130;
  }
  
  function getDeviceName(dev){
    var deviceName = {
      90: "R313WA"
    };
    return deviceName[dev];
  }
  
  function getDeviceID(devName){
    var deviceName = {
      "R313WA": 90
    };
  
    return deviceName[devName];
  }
  
  function padLeft(str, len) {
      str = '' + str;
      if (str.length >= len) {
          return str;
      } else {
          return padLeft("0" + str, len);
      }
  }
  
  function decodeUplink(input) {
    var data = {};
    switch (input.fPort) {
      case 6:
          if (input.bytes[2] === 0x00)
          {
              data.Device = getDeviceName(input.bytes[1]);
              data.SWver =  input.bytes[3]/10;
              data.HWver =  input.bytes[4];
              data.Datecode = padLeft(input.bytes[5].toString(16), 2) + padLeft(input.bytes[6].toString(16), 2) + padLeft(input.bytes[7].toString(16), 2) + padLeft(input.bytes[8].toString(16), 2);
              
              return {
                  data: data,
              };
          }
          
          data.Device = getDeviceName(input.bytes[1]);
          if (input.bytes[3] & 0x80)
          {
              var tmp_v = input.bytes[3] & 0x7F;
              data.Volt = (tmp_v / 10).toString() + '(low battery)';
          }
          else
              data.Volt = input.bytes[3]/10;
  
          data.Status_1 = (input.bytes[4] == 0x00) ? 0 : 1;
          data.Status_2 = (input.bytes[5] == 0x00) ? 0 : 1;
  
          break;
          
      case 7:
          data.Cmd = getCfgCmd(input.bytes[0]);
          data.Device = getDeviceName(input.bytes[1]);
          if (input.bytes[0] === getCmdToID("ConfigReportRsp"))
          {
              data.Status = (input.bytes[2] === 0x00) ? 'Success' : 'Failure';
          }
          else if (input.bytes[0] === getCmdToID("ReadConfigReportRsp"))
          {
              data.MinTime = (input.bytes[2]<<8 | input.bytes[3]);
              data.MaxTime = (input.bytes[4]<<8 | input.bytes[5]);
              data.BatteryChange = input.bytes[6]/10;
              data.SensorDisableTime = (input.bytes[7]<<8 | input.bytes[8]);
              data.SensorDetectionTime = (input.bytes[9]<<8 | input.bytes[10]);
          }
          
          break;	
  
      default:
        return {
          errors: ['unknown FPort'],
        };
        
      }
            
      return {
          data: data,
      };
   }
    
  function encodeDownlink(input) {
    var ret = [];
    var devid;
    var getCmdID;
        
    getCmdID = getCmdToID(input.data.Cmd);
    devid = getDeviceID(input.data.Device);
  
    if (input.data.Cmd == "ConfigReportReq")
    {
        var mint = input.data.MinTime;
        var maxt = input.data.MaxTime;
        var batteryChg = input.data.BatteryChange * 10;
        var time1 = input.data.SensorDisableTime;
        var time2 = input.data.SensorDetectionTime;
        
        ret = ret.concat(getCmdID, devid, (mint >> 8), (mint & 0xFF), (maxt >> 8), (maxt & 0xFF), batteryChg, (time1 >> 8), (time1 & 0xFF), (time2 >> 8), (time2 & 0xFF));
    }
    else if (input.data.Cmd == "ReadConfigReportReq")
    {
        ret = ret.concat(getCmdID, devid, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
    }  
    
    return {
      fPort: 7,
      bytes: ret
    };
  }  
    
  function decodeDownlink(input) {
    var data = {};
    switch (input.fPort) {
      case 7:
          data.Cmd = getCfgCmd(input.bytes[0]);
          data.Device = getDeviceName(input.bytes[1]);
          if (input.bytes[0] === getCmdToID("ConfigReportReq"))
          {
              data.MinTime = (input.bytes[2]<<8 | input.bytes[3]);
              data.MaxTime = (input.bytes[4]<<8 | input.bytes[5]);
              data.BatteryChange = input.bytes[6]/10;
              data.SensorDisableTime = (input.bytes[7]<<8 | input.bytes[8]);
              data.SensorDetectionTime = (input.bytes[9]<<8 | input.bytes[10]);
          }
  
          break;
          
      default:
        return {
          errors: ['invalid FPort'],
        };
    }
    
    return {
          data: data,
      };
  }